//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class ExceptionMain 
	{
		private void ThrowException()
		{
			throw new ApplicationException("Zgaszanie wyjtku z RecurseException");
		}
		private void ExceptionThread()
		{
			try
			{
				while(true)
				{
					try
					{
						ThrowException();
					}
					catch(ApplicationException)
					{
						TimeSpan ts = new TimeSpan(Environment.TickCount);
						Console.WriteLine("{0}", ts.ToString());
					}
					// Wyjtek bdzie zgaszany co p sekundy.
					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("RecurseExceptionThread przerywa prac: {0}", e.Message);
			}
		}
		private void TestThread()
		{
			Thread re = new Thread(new ThreadStart(ExceptionThread));
			try
			{
				re.Start();
				Thread.Sleep(Timeout.Infinite);
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
				re.Abort();
			}
		}
		static void Main(string [] args)
		{
			ExceptionMain m = new ExceptionMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}